/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.api;

import filenet.vw.base.logging.Logger;
import filenet.vw.toolkit.utils.table.IVWSortItem;
import filenet.ws.api.WSDefinition;
import filenet.ws.api.WSFault;
import filenet.ws.api.WSMessage;
import filenet.ws.api.WSParam;
import filenet.ws.api.WSPortType;
import filenet.ws.api.WSTemplateBase;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Fault;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;

public class WSOperation
implements IVWSortItem {
    protected static Logger logger = Logger.getLogger("filenet.ws.api");
    private static String m_className = "WSOperation";
    private WSDefinition m_definition = null;
    private WSPortType m_portType = null;
    private Operation m_operation = null;
    private String[] m_parameterOrdering = null;
    private WSMessage m_inMsg = null;
    private WSMessage m_outMsg = null;
    private WSFault[] m_faults = null;

    public static String _get_FILE_DATE() {
        return "$Date:   10 Sep 2008 10:00:22  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   ysoong  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.19  $";
    }

    public void releaseReferences() {
        block6: {
            try {
                int i;
                this.m_definition = null;
                this.m_portType = null;
                this.m_operation = null;
                if (this.m_parameterOrdering != null) {
                    for (i = 0; i < this.m_parameterOrdering.length; ++i) {
                        if (this.m_parameterOrdering[i] == null) continue;
                        this.m_parameterOrdering[i] = null;
                    }
                    this.m_parameterOrdering = null;
                }
                this.m_inMsg = null;
                this.m_outMsg = null;
                if (this.m_faults != null) {
                    for (i = 0; i < this.m_faults.length; ++i) {
                        if (this.m_faults[i] == null) continue;
                        this.m_faults[i].releaseReferences();
                        this.m_faults[i] = null;
                    }
                    this.m_faults = null;
                }
            }
            catch (Exception ex) {
                if (!logger.isFinest()) break block6;
                logger.throwing(m_className, "releaseReferences", ex);
            }
        }
    }

    public WSOperation(WSDefinition definition, WSPortType portType, Operation operation) {
        this.m_definition = definition;
        this.m_portType = portType;
        this.m_operation = operation;
        if (operation != null) {
            Map map;
            Message outMsg;
            Output out;
            Message inMsg;
            Input in = operation.getInput();
            if (in != null && (inMsg = in.getMessage()) != null) {
                this.m_inMsg = this.m_definition.getMessage(inMsg);
            }
            if ((out = operation.getOutput()) != null && (outMsg = out.getMessage()) != null) {
                this.m_outMsg = this.m_definition.getMessage(outMsg);
            }
            if (!(map = operation.getFaults()).isEmpty()) {
                Iterator it;
                this.m_faults = new WSFault[map.size()];
                Collection collection = map.values();
                if (collection != null && (it = collection.iterator()) != null) {
                    int i = 0;
                    Object obj = null;
                    while (it.hasNext()) {
                        obj = it.next();
                        if (obj == null || !(obj instanceof Fault)) continue;
                        this.m_faults[i++] = new WSFault(this.m_definition, obj);
                    }
                }
            }
        }
    }

    public Operation getOperation() {
        return this.m_operation;
    }

    public String getName() {
        if (this.m_operation != null) {
            return this.m_operation.getName();
        }
        return null;
    }

    public String getDisplayName() {
        if (this.m_operation != null) {
            return this.m_operation.getName();
        }
        return null;
    }

    public String toString() {
        return this.m_operation.toString();
    }

    public WSMessage getInMessage() {
        return this.m_inMsg;
    }

    public String getExpressionInMessageTemplate() throws Exception {
        if (this.m_inMsg != null) {
            return this.m_inMsg.getExpressionMessageTemplate(this.getParameterOrdering());
        }
        return new String();
    }

    public String getXMLInMessageTemplate() throws Exception {
        if (this.m_inMsg != null) {
            return this.m_inMsg.getXMLMessageTemplate(this.getParameterOrdering());
        }
        return new String();
    }

    public String[] getInMessageNameSpaces() {
        if (this.m_inMsg != null) {
            return this.m_inMsg.getNameSpaces();
        }
        return null;
    }

    public WSMessage getOutMessage() {
        return this.m_outMsg;
    }

    public String getExpressionOutMessageTemplate() throws Exception {
        if (this.m_outMsg != null) {
            return this.m_outMsg.getExpressionMessageTemplate(this.getParameterOrdering());
        }
        return new String();
    }

    public String getXMLOutMessageTemplate() throws Exception {
        if (this.m_outMsg != null) {
            return this.m_outMsg.getXMLMessageTemplate(this.getParameterOrdering());
        }
        return new String();
    }

    public String[] getOutMessageNameSpaces() {
        if (this.m_outMsg != null) {
            return this.m_outMsg.getNameSpaces();
        }
        return null;
    }

    public String[] getFaultTemplates() throws Exception {
        if (this.m_faults != null && this.m_faults.length > 0) {
            String[] s = new String[this.m_faults.length];
            for (int i = 0; i < this.m_faults.length; ++i) {
                if (this.m_faults[i] == null) continue;
                s[i] = this.m_faults[i].getFaultTemplate();
            }
            return s;
        }
        return null;
    }

    public String[] getFaultNames() {
        if (this.m_faults != null && this.m_faults.length > 0) {
            String[] names = new String[this.m_faults.length];
            for (int i = 0; i < this.m_faults.length; ++i) {
                if (this.m_faults[i] == null) continue;
                names[i] = this.m_faults[i].getName();
            }
            return names;
        }
        return null;
    }

    public WSFault[] getFaults() {
        return this.m_faults;
    }

    public String[] getParameterOrdering() {
        List list;
        if (this.m_parameterOrdering != null) {
            return this.m_parameterOrdering;
        }
        if (this.m_operation != null && (list = this.m_operation.getParameterOrdering()) != null && list.size() > 0) {
            Object obj = null;
            this.m_parameterOrdering = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                obj = list.get(i);
                if (obj == null || !(obj instanceof String)) continue;
                this.m_parameterOrdering[i] = obj;
            }
        }
        return this.m_parameterOrdering;
    }

    public WSParam[] getInMsgParamList() {
        if (this.m_inMsg != null) {
            return WSTemplateBase.orderParameters(this.m_inMsg.getParamList(), this.getParameterOrdering());
        }
        return null;
    }

    public WSParam[] getFlatInMsgParamList() {
        return WSTemplateBase.toFlatParamList(this.getInMsgParamList());
    }

    public WSParam[] getOutMsgParamList() {
        if (this.m_outMsg != null) {
            return WSTemplateBase.orderParameters(this.m_outMsg.getParamList(), this.getParameterOrdering());
        }
        return null;
    }

    public WSParam[] getFlatOutMsgParamList() {
        return WSTemplateBase.toFlatParamList(this.getOutMsgParamList());
    }

    public String getInputName() {
        if (this.m_operation != null && this.m_operation.getInput() != null) {
            return this.m_operation.getInput().getName();
        }
        return null;
    }

    public String getOutputName() {
        if (this.m_operation != null && this.m_operation.getOutput() != null) {
            return this.m_operation.getOutput().getName();
        }
        return null;
    }
}

